/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class HTMacModifyWizard
implements JDMWizardPanelDelegate {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8260.Resources");
    protected JdmBrowser browser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        DestinationPropBook destinationPropBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        this.browser = (JdmBrowser)destinationPropBook.getBrowser();
        Hashtable hashtable = jDMWizardInfo.getItems();
        GenModel genModel = jDMWizardInfo.getModel();
        try {
            ModelInfo modelInfo = genModel.getInfo("Spec");
            if (hashtable != null) {
                hashtable.put("hTMACModInterfaceMode", modelInfo.get("Spec.HTMACModInterfaceMode"));
                hashtable.put("hTMACModTRMacAddrType", modelInfo.get("Spec.HTMACModTRMacAddrType"));
                hashtable.put("hTMACModTRLocAdminAddr", modelInfo.get("Spec.HTMACModTRLocAdminAddr"));
                hashtable.put("hTMACModTREarlyTokenRel", modelInfo.get("Spec.HTMACModTREarlyTokenRel"));
                hashtable.put("hTMACModTRMonitorConten", modelInfo.get("Spec.HTMACModTRMonitorConten"));
                hashtable.put("hTMACModTRInternalWrap", modelInfo.get("Spec.HTMACModTRInternalWrap"));
                hashtable.put("hTMACModTRExternalWrap", modelInfo.get("Spec.HTMACModTRExternalWrap"));
                hashtable.put("hTMACModDot5StatsMode", modelInfo.get("Spec.HTMACModDot5StatsMode"));
                hashtable.put("hTMACModRMONSurrogateStatsMode", modelInfo.get("Spec.HTMACModRMONSurrogateStatsMode"));
                hashtable.put("hTMACModARPResolveMethod", modelInfo.get("Spec.HTMACModARPResolveMethod"));
                hashtable.put("hTMACModProbeIpAddress", modelInfo.get("Spec.HTMACModProbeIpAddress"));
                hashtable.put("hTMACModProbeSubnetMask", modelInfo.get("Spec.HTMACModProbeSubnetMask"));
                hashtable.put("hTMACModProbeDefaultGateway", modelInfo.get("Spec.HTMACModProbeDefaultGateway"));
                hashtable.put("readytogo", "yes");
                this.displayMsg("HTMac_modifyConfirm");
                return;
            }
            this.displayMsg("HTMac_modifyNoConfirm");
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            return;
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg("HTMac_modifyAbort");
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string = "proceed";
        boolean bl = true;
        GenModel genModel = jDMWizardInfo.getModel();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (hashtable.get("readytogo").equals("yes")) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Spec.HTMACModInterfaceMode", (Integer)hashtable.get("hTMACModInterfaceMode"));
            int n = (Integer)hashtable.get("hTMACModInterfaceMode");
            if (n != 1) {
                modelInfo.add("Spec.HTMACModTRMacAddrType", (Integer)hashtable.get("hTMACModTRMacAddrType"));
                modelInfo.add("Spec.HTMACModTRLocAdminAddr", (OctetString)hashtable.get("hTMACModTRLocAdminAddr"));
            }
            modelInfo.add("Spec.HTMACModTREarlyTokenRel", (Integer)hashtable.get("hTMACModTREarlyTokenRel"));
            modelInfo.add("Spec.HTMACModTRMonitorConten", (Integer)hashtable.get("hTMACModTRMonitorConten"));
            modelInfo.add("Spec.HTMACModTRInternalWrap", (Integer)hashtable.get("hTMACModTRInternalWrap"));
            modelInfo.add("Spec.HTMACModTRExternalWrap", (Integer)hashtable.get("hTMACModTRExternalWrap"));
            modelInfo.add("Spec.HTMACModDot5StatsMode", (Integer)hashtable.get("hTMACModDot5StatsMode"));
            modelInfo.add("Spec.HTMACModRMONSurrogateStatsMode", (Integer)hashtable.get("hTMACModRMONSurrogateStatsMode"));
            modelInfo.add("Spec.HTMACModARPResolveMethod", (Integer)hashtable.get("hTMACModARPResolveMethod"));
            IPAddress iPAddress = (IPAddress)hashtable.get("hTMACModProbeIpAddress");
            if (!iPAddress.toString().equals("0.0.0.0")) {
                modelInfo.add("Spec.HTMACModProbeIpAddress", iPAddress);
            }
            if (!(iPAddress = (IPAddress)hashtable.get("hTMACModProbeSubnetMask")).toString().equals("0.0.0.0")) {
                modelInfo.add("Spec.HTMACModProbeSubnetMask", (IPAddress)hashtable.get("hTMACModProbeSubnetMask"));
            }
            if (!(iPAddress = (IPAddress)hashtable.get("hTMACModProbeDefaultGateway")).toString().equals("0.0.0.0")) {
                modelInfo.add("Spec.HTMACModProbeDefaultGateway", (IPAddress)hashtable.get("hTMACModProbeDefaultGateway"));
            }
            try {
                modelInfo = genModel.setInfo("Spec", modelInfo);
                bl = this.checkSetInfo(modelInfo);
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
                bl = false;
            }
        }
        if (bl) {
            this.displayMsg("HTMac_modifyOK");
        } else {
            this.displayMsg("HTMac_modifyError");
        }
        return bl;
    }

    private boolean checkSetInfo(ModelInfo modelInfo) {
        String string = "checkSetInfo";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Got a special value for ID -> " + string2);
            }
            return false;
        }
        return true;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(HTMacModifyWizard.getNLSString(string));
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

